#ifndef __CCursor__
#define __CCursor__

#include <Basics/CCountedObject.hpp>
using Exponent::Basics::CCountedObject;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Windowing
		{
			/**
			 * @class CCursor CCursor.hpp
			 * @brief A cursor representation
			 *
			 * @date 19/09/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CCursor.hpp,v 1.4 2007/02/08 21:07:54 paul Exp $
			 */
			class CCursor : public CCountedObject
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				static CCursor CCURSOR_ARROW;		/**< Arrow (normal) */
				static CCursor CCURSOR_HAND;		/**< Hand */
				static CCursor CCURSOR_IBEAM;		/**< Text beam */
				static CCursor CCURSOR_RESIZE;		/**< Resize */
				static CCursor CCURSOR_HOUR;		/**< Timer / Hourglass */
				static CCursor CCURSOR_UP_DOWN;		/**< Up down drag */
				static CCursor CCURSOR_LEFT_RIGHT;	/**< Left right drag */
				static CCursor CCURSOR_SIZE_ALL;	/**< Size both directions */

//	===========================================================================

				/**
				 * @enum EMouseCursor
				 * @brief System cursors
				 */
				enum EMouseCursor
				{
					e_arrowCursor = 0,				/**< Arrow (normal) */
					e_handCursor,					/**< Hand */
					e_hourGlassCursor,				/**< Hour glass, beachball */
					e_upDownArrowCursor,			/**< Up down arrow head */
					e_leftRightArrowCursor,			/**< Left dright arrow head */
					e_iBeamCursor,					/**< Text IBeam */
					e_resizeCursor,					/**< resize cursor */
					e_sizeAllCursor,				/**< Size all */			
					
					e_numberOfCursors,				/**< Total number of cursor types */
				};

//	===========================================================================

				/**
				 * Construction
				 * @param cursor The cursor to use
				 */
				CCursor(EMouseCursor cursor = e_arrowCursor);

				/** @cond */
				#ifdef WIN32
				/** @endcond */
					/**
					 * Construction
					 * @param instance Application instance
					 * @param resourceId The resource id of the cursor to load from the app
					 */
					CCursor(HINSTANCE instance, const long resourceId);
				/** @cond */
				#else
				/** @endcond */
					/**
					 * Constuction
					 * @param resourceId The resource id of the cursor to load
					 */
					CCursor(const long resourceId);
				/** @cond */
				#endif
				/** @endcond */

				/**
				 * Destruction
				 */
				virtual ~CCursor();

//	===========================================================================

				/** @cond */
				#ifdef WIN32
				/** @endcond */
					/**
					 * Get the windows cursor handle
					 * @retval HCURSOR The windows cursor
					 */
					HCURSOR getCursor() const;
					
					/**
					 * Set the cursor from a resource id
					 * @param instance Application instance
					 * @param resourceId The resource id of the cursor to load from the app
					 */
					void setCursor(HINSTANCE instance, const long resourceId);

					/**
					 * Load an animated cursor
					 * @param instance Application instance
					 * @param resourceId The resource id of the cursor to load from the app
					 */
					void setAnimatedCursor(HINSTANCE instance, const unsigned long resourceId);
				/** @cond */
				#else
				/** @endcond */
					/**
					 * Get the cursor
					 * @retval CCrsrHandle The mac format cursor
					 */
					CCrsrHandle getCursor() const;

					/**
					 * Get the cursor id
					 * @retval EMouseCursor The mouse cursor
					 */
					EMouseCursor getCursorId() const { return m_cursorId; }

					/**
					 * Set the cursor from a resource id
					 * @param resourceId The resource id of the cursor to load
					 */
					void setCursor(const long resourceId);
				/** @cond */
				#endif
				/** @endcond */

//	===========================================================================

				/**
				 * Set the cursor form a system id
				 * @param cursor The mouse cursor
				 */
				void setCursor(EMouseCursor cursor);

//	===========================================================================

				/**
				 * Show the cursor
				 */
				void showCursor();

				/**
				 * Hide the cursor
				 */
				void hideCursor();

//	===========================================================================

			protected:

//	===========================================================================

				/** @cond */
				#ifdef WIN32
				/** @endcond */
					HCURSOR m_cursor;				/**< pointer to the cursor */
				/** @cond */
				#else
				/** @endcond */
					EMouseCursor m_cursorId;		/**< the id of the cursor */
					CCrsrHandle m_cursor;			/**< Handle to the cursor */
				/** @cond */
				#endif
				/** @endcond */
			};
		}
	}
}
#endif	// End of CCursor.hpp